/*---------------------------------------------------------------
Copyright 2020 Le Filament
License AGPL-3.0 or later (https://www.gnu.org/licenses/agpl).
------------------------------------------------------------------*/

odoo.define('cgscop_alfresco.form_widgets', function(require) {
    "use strict";

    var core = require('web.core');
    var form_widgets = require('cmis_web.form_widgets');
    var lf_form_widgets = require('lefilament_alfodoo.form_widgets');
    var session = require('web.session');

    form_widgets.CmisObjectWrapper.include({
        /*
        * Surcharge les fonction parse_object (téléchargement)
        * et get_content_url (preview) pour passer le ticket
        * l'url appelée
        */
        parse_object: function (cmis_object) {
            this._super.apply(this, arguments);
            if (this.cmis_session.alf_ticket) {
                this.url = this.cmis_session.getContentStreamURL(this.objectId, 'attachment', {'alf_ticket': this.cmis_session.alf_ticket});
            }
        },
        get_content_url: function () {
            var options = {}
            if (this.cmis_session.alf_ticket) {
                options = {'alf_ticket': this.cmis_session.alf_ticket};
            }
            return this.cmis_session.getContentStreamURL(this.objectId, 'inline', options);
        },
    }),

    form_widgets.FieldCmisFolder.include({
        /**
        * Surcharge la fonction d'initialisation de la session CMIS pour
        * passer le token de l'utilisateur
        */
        init_cmis_session: function () {
            var self = this;
            $.when(this.cmis_config_loaded).done(function () {
                self.cmis_session = cmis.createSession(self.cmis_location);
                self.cmis_session.setGlobalHandlers(self.on_cmis_error, self.on_cmis_error);

                // CGSCOP : appel vers la fonction custom
                self._rpc({route:'/web/alfresco/session', params:{
                    'username': session.username
                }}).done(function (result) {
                    self.cmis_session['alf_ticket'] = result;
                    self.cmis_session.setCredentials('ROLE_TICKET', result);
                });
                self.cmis_session_initialized.resolve();
                self.cmis_session.setCharacterSet(document.characterSet);
            });
        },

        load_cmis_repositories: function () {
            /**
            * Surcharge la fonction de chargement des repositories après initialisation
            * du dossier initial pour recharger correctement la page
            */
            var dfd = $.Deferred();
            var self = this;
            if (this.cmis_session.repositories) {
                return dfd.resolve();
            } else {
                if (self.cmis_session.alf_ticket) {
                    self.cmis_session
                    .loadRepositories()
                    .ok(function (data) {
                        dfd.resolve();
                    })
                    .notOk(function (error) {
                        self.on_cmis_error(error);
                        dfd.reject(error);
                    });
                } else {
                    // CGSCOP : appel vers la fonction custom
                    self._rpc({route:'/web/alfresco/session', params:{
                        'username': session.username
                    }}).done(function (result) {
                        self.cmis_session['alf_ticket'] = result;
                        self.cmis_session.setCredentials('ROLE_TICKET', result);
                        self.cmis_session
                        .loadRepositories()
                        .ok(function (data) {
                            dfd.resolve();
                        })
                        .notOk(function (error) {
                            self.on_cmis_error(error);
                            dfd.reject(error);
                        });
                    });
                }
            }
            return dfd.promise();
        },

    });

    lf_form_widgets.CmisMetadataDialog.include({
        /*
        * Surcharge la fonction on_click_metadata
        * pour la gestion des erreurs spécifique à la CG Scop
        */
        on_click_metadata: function () {
            var self = this;
            this.metadata = {'cmis:name': Date.now().toString() + '_' + this.file.name}
            _.each(this.parent_metadata, function (meta) {
                if (meta.value) {
                    self.metadata[meta.name] = meta.value;
                } else if (meta.field_value) {
                    self.metadata[meta.name] = self.record[meta.field_value];
                } else {
                    self.metadata[meta.name] = self.$el.find("#" + meta.name.replace(":", "-"))[0].value;
                }
            });
            this.cmis_session
                .createDocument(this.parent_cmisobject.objectId, this.file, this.metadata, this.file.mimeType)
                .ok(function (new_cmisobject) {
                    self.getParent().trigger('cmis_node_created', [new_cmisobject]);
                    self.$el.parents('.modal').modal('hide');
                })
                .notOk(function (error) {
                        console.log(error)
                        if (error) {
                            console.error(error.text);
                            if (error.type == 'application/json') {
                                var jerror = JSON.parse(error.text);
                                if (jerror.exception === 'objectNotFound') {
                                        self.getParent().refresh_datatable();
                                        self.$el.parents('.modal').modal('hide');
                                        return;
                                }
                           }
                        }
                });
        },

    });
});